<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/wp-amp/parts/shop_sort_block.php.
 *
 * @var $this AMPHTML_WC
 */
global $wp;
$current_url = add_query_arg($wp->query_string, '', home_url($wp->request));

$catalog_orderby_options = array(
    'menu_order' => __( 'Default sorting', 'woocommerce' ),
);
if ( $this->options->get( 'shop_popularity' ) ){
    $catalog_orderby_options['popularity'] = __( 'Sort by popularity', 'woocommerce' );
}
if ( $this->options->get( 'shop_average_rating' ) ){
    $catalog_orderby_options['rating'] =  __( 'Sort by average rating', 'woocommerce' );
}
if ( $this->options->get( 'shop_date' ) ){
    $catalog_orderby_options['date'] = __( 'Sort by latest', 'woocommerce' );
}
if ( $this->options->get( 'shop_price_asc' ) ){
    $catalog_orderby_options['price'] = __( 'Sort by price: low to high', 'woocommerce' );
}
if ( $this->options->get( 'shop_price_desc' ) ){
    $catalog_orderby_options['price-desc'] = __( 'Sort by price: high to low', 'woocommerce' );
}
?>

<form class="woocommerce-ordering" action="<?php echo $current_url;?>" target="_top" method="get">
    <select name="orderby" class="orderby">
        <?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
            <option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
        <?php endforeach; ?>
    </select>
    <input type="hidden" name="paged" value="1" />
    <input class="i-button" type="submit" value="<?php _e( 'Sort', 'amphtml');?>"/>
    <?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
</form>

